<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CGalleryWidgetAlbumsWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Albums w/ Carousel",
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		switch ($widget["settings"]["set_show"]) {
			default:
			case "1":
				$order = " rand() ";
			break;

			case "2":
				$order = " cat_date DESC ";
			break;

			case "3":
				$order = " cat_date ASC ";
			break;

			case "4":
				$order = " cat_date DESC ";
				$widget["settings"]["set_items"] = "9999";
				$cond = " AND c.cat_id in (" . $widget["settings"]["set_manual"] .") ";
			break;

		}

		$items = $this->db->QFetchRowArray("
			SELECT * FROM
				{$this->tables['plugin:gallery_cats']} as c,
				{$this->tables['plugin:gallery_cats_lang']} as l
			WHERE
				c.cat_id=l.cat_id AND 
				l.lang_id={$widget[lang_id]} AND 
				c.module_id={$widget[widget_module]} AND 
				c.cat_status = 1 AND 
				c.cat_date <= " . time() . "			
				{$cond}

			ORDER BY $order
			LIMIT {$widget[settings][set_items]}"
		);


		if (is_Array($items)) {

			global $base;

			$elements = explode("," , $widget["settings"]["set_elements"]);

			foreach ($items as $key => $val) {
				$val["link"] = $items[$key]["link"] = $widget["link"] . $val["cat_url"] .  "-" . $val["cat_id"] . "/";
				$items[$key]["image"] = $widget["settings"]["set_height"] ? "upload/gallery/albums/tn_{$val[cat_id]}.jpg" : "upload/gallery/albums/{$val[cat_id]}.jpg";				

				$items[$key]["_title"] = $items[$key]["_date"] = $items[$key]["_brief"] = $items[$key]["_images"] = "";


				if (in_array("date", $elements )) {
					$items[$key]["_date"] = $this->tpl->blockReplace(
						"Date" ,
						array(
							"date" => Cdate::ToStr($widget["mod_settings"]["set_date_album"] , $val["cat_date"])
						)
					);
				} 


				if (in_array("title" , $elements)) {
					$items[$key]["_title"] = $this->tpl->blockreplace(
						"Title",
						$val
					);
				} 				


				if (in_array("brief" , $elements) && $val["cat_brief"]) {
					$val["cat_brief"] = nl2br($val["cat_brief"]);

					$items[$key]["_brief"] = $this->tpl->blockreplace(
						"Brief",
						$val
					);
				} 				

				if (in_array("images", $elements )) {

					$items[$key]["_images"] = $this->tpl->blockReplace(
						"Images" ,
						array(
							"images" => $this->db->RowCount(
								$this->tables["plugin:media"],
								"where module_id={$val[module_id]} AND item_parent={$val[cat_id]}"
							)
						)
					);
				} 


			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"items"	=> $base->html->Table(
						$this->tpl , 
						"",
						$items
					),

					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

				),
				$widget["settings"],
				$widget,
				$widget["mod_settings"]
			);

			
		}
		
	}
	
	

}


?>